/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.scoring.Achievement;
import com.skloch.game.scoring.Score;
import com.skloch.game.screens.AchievementScreen;
import com.skloch.game.screens.LeaderboardScreenGame;
import com.skloch.game.screens.MenuScreen;

public class GameOverScreen
implements Screen {
    private HustleGame game;
    Stage gameOverStage;
    Viewport viewport;
    OrthographicCamera camera;
    private final Score score;
    private int scoreToPass = 10000;

    public GameOverScreen(final HustleGame game) {
        this.game = game;
        this.gameOverStage = new Stage(new FitViewport(game.width, game.height));
        Gdx.input.setInputProcessor(this.gameOverStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.width, (float)game.height, this.camera);
        this.camera.setToOrtho(false, game.width, game.height);
        Window gameOverWindow = new Window("", game.skin);
        this.gameOverStage.addActor(gameOverWindow);
        Table gameOverTable = new Table();
        gameOverWindow.add(gameOverTable);
        Table scoreTable = new Table();
        gameOverWindow.add(scoreTable).prefHeight(600.0f);
        Table scrollTable = new Table();
        ScrollPane scrollWindow = new ScrollPane((Actor)scrollTable, game.skin);
        scrollWindow.setFadeScrollBars(false);
        scoreTable.add(scrollWindow).padTop(5.0f).height(530.0f).width(550.0f);
        Label title = new Label("Game Over!", game.skin, "button");
        Label winlose = Score.getInstance().getTotalScore() >= this.scoreToPass ? new Label("You passed the exam!", game.skin, "button") : new Label("You failed the exam :(", game.skin, "button");
        scrollTable.add(title).padTop(10.0f);
        scrollTable.row();
        scrollTable.add(winlose).padTop(10.0f);
        scrollTable.row();
        this.score = Score.getInstance();
        int totalScore = this.score.getTotalScore();
        scrollTable.add(new Label("Total Score", game.skin, "interaction")).padBottom(5.0f);
        scrollTable.row();
        scrollTable.add(new Label(String.valueOf(totalScore), game.skin, "button")).padBottom(20.0f);
        scrollTable.row();
        Label text = new Label(Score.getInstance().getUserScores(), game.skin, "interaction");
        text.setWrap(true);
        scrollTable.add(text).width(500.0f).padLeft(15.0f);
        Table buttonTable = new Table();
        scoreTable.add(buttonTable).padTop(0.0f).height(530.0f).width(300.0f).padLeft(25.0f);
        TextButton achievementsButton = new TextButton("Achievements", game.skin);
        buttonTable.add(achievementsButton).width(300.0f).padTop(10.0f);
        buttonTable.row();
        TextButton leaderboardButton = new TextButton("Leaderboard", game.skin);
        buttonTable.add(leaderboardButton).width(300.0f).padTop(10.0f);
        buttonTable.row();
        TextButton exitButton = new TextButton("Main Menu", game.skin);
        buttonTable.add(exitButton).width(300.0f).padTop(10.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.soundManager.overworldMusic.stop();
                GameOverScreen.this.dispose();
                game.setScreen(new MenuScreen(game));
                GameOverScreen.this.score.resetScores();
                Achievement.getInstance().resetAllAchievements();
            }
        });
        leaderboardButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                GameOverScreen.this.dispose();
                game.setScreen(new LeaderboardScreenGame(game));
            }
        });
        GameOverScreen thisScreen = this;
        achievementsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                game.setScreen(new AchievementScreen(game));
            }
        });
        gameOverWindow.pack();
        gameOverWindow.setSize(1000.0f, 600.0f);
        gameOverWindow.setX(this.viewport.getWorldWidth() / 2.0f - gameOverWindow.getWidth() / 2.0f);
        gameOverWindow.setY(this.viewport.getWorldHeight() / 2.0f - gameOverWindow.getHeight() / 2.0f);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        this.game.blueBackground.draw();
        this.gameOverStage.act(delta);
        this.gameOverStage.draw();
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.gameOverStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

